<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * CatalogCustomAttributeValue Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class CatalogCustomAttributeValue implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'name' => 'string',
        'string_value' => 'string',
        'custom_attribute_definition_id' => 'string',
        'type' => 'string',
        'number_value' => 'string',
        'boolean_value' => 'bool',
        'selection_uid_values' => 'string[]',
        'key' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'name' => 'name',
        'string_value' => 'string_value',
        'custom_attribute_definition_id' => 'custom_attribute_definition_id',
        'type' => 'type',
        'number_value' => 'number_value',
        'boolean_value' => 'boolean_value',
        'selection_uid_values' => 'selection_uid_values',
        'key' => 'key'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'name' => 'setName',
        'string_value' => 'setStringValue',
        'custom_attribute_definition_id' => 'setCustomAttributeDefinitionId',
        'type' => 'setType',
        'number_value' => 'setNumberValue',
        'boolean_value' => 'setBooleanValue',
        'selection_uid_values' => 'setSelectionUidValues',
        'key' => 'setKey'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'name' => 'getName',
        'string_value' => 'getStringValue',
        'custom_attribute_definition_id' => 'getCustomAttributeDefinitionId',
        'type' => 'getType',
        'number_value' => 'getNumberValue',
        'boolean_value' => 'getBooleanValue',
        'selection_uid_values' => 'getSelectionUidValues',
        'key' => 'getKey'
    );
  
    /**
      * $name The name of the custom attribute.
      * @var string
      */
    protected $name;
    /**
      * $string_value The string value of the custom attribute.  Populated if `type` = `STRING`.
      * @var string
      */
    protected $string_value;
    /**
      * $custom_attribute_definition_id __Read-only.__ The id of the `CatalogCustomAttributeDefinition` this value belongs to.
      * @var string
      */
    protected $custom_attribute_definition_id;
    /**
      * $type __Read-only.__ A copy of type from the associated `CatalogCustomAttributeDefinition`. See [CatalogCustomAttributeDefinitionType](#type-catalogcustomattributedefinitiontype) for possible values
      * @var string
      */
    protected $type;
    /**
      * $number_value Populated if `type` = `NUMBER`. Contains a string representation of a decimal number, using a `.` as the decimal separator.
      * @var string
      */
    protected $number_value;
    /**
      * $boolean_value A `true` or `false` value. Populated if `type` = `BOOLEAN`.
      * @var bool
      */
    protected $boolean_value;
    /**
      * $selection_uid_values One or more choices from `allowed_selections`. Populated if `type` = `SELECTION`.
      * @var string[]
      */
    protected $selection_uid_values;
    /**
      * $key __Read-only.__ A copy of key from the associated `CatalogCustomAttributeDefinition`.
      * @var string
      */
    protected $key;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["name"])) {
              $this->name = $data["name"];
            } else {
              $this->name = null;
            }
            if (isset($data["string_value"])) {
              $this->string_value = $data["string_value"];
            } else {
              $this->string_value = null;
            }
            if (isset($data["custom_attribute_definition_id"])) {
              $this->custom_attribute_definition_id = $data["custom_attribute_definition_id"];
            } else {
              $this->custom_attribute_definition_id = null;
            }
            if (isset($data["type"])) {
              $this->type = $data["type"];
            } else {
              $this->type = null;
            }
            if (isset($data["number_value"])) {
              $this->number_value = $data["number_value"];
            } else {
              $this->number_value = null;
            }
            if (isset($data["boolean_value"])) {
              $this->boolean_value = $data["boolean_value"];
            } else {
              $this->boolean_value = null;
            }
            if (isset($data["selection_uid_values"])) {
              $this->selection_uid_values = $data["selection_uid_values"];
            } else {
              $this->selection_uid_values = null;
            }
            if (isset($data["key"])) {
              $this->key = $data["key"];
            } else {
              $this->key = null;
            }
        }
    }
    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
  
    /**
     * Sets name
     * @param string $name The name of the custom attribute.
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Gets string_value
     * @return string
     */
    public function getStringValue()
    {
        return $this->string_value;
    }
  
    /**
     * Sets string_value
     * @param string $string_value The string value of the custom attribute.  Populated if `type` = `STRING`.
     * @return $this
     */
    public function setStringValue($string_value)
    {
        $this->string_value = $string_value;
        return $this;
    }
    /**
     * Gets custom_attribute_definition_id
     * @return string
     */
    public function getCustomAttributeDefinitionId()
    {
        return $this->custom_attribute_definition_id;
    }
  
    /**
     * Sets custom_attribute_definition_id
     * @param string $custom_attribute_definition_id __Read-only.__ The id of the `CatalogCustomAttributeDefinition` this value belongs to.
     * @return $this
     */
    public function setCustomAttributeDefinitionId($custom_attribute_definition_id)
    {
        $this->custom_attribute_definition_id = $custom_attribute_definition_id;
        return $this;
    }
    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
  
    /**
     * Sets type
     * @param string $type __Read-only.__ A copy of type from the associated `CatalogCustomAttributeDefinition`. See [CatalogCustomAttributeDefinitionType](#type-catalogcustomattributedefinitiontype) for possible values
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Gets number_value
     * @return string
     */
    public function getNumberValue()
    {
        return $this->number_value;
    }
  
    /**
     * Sets number_value
     * @param string $number_value Populated if `type` = `NUMBER`. Contains a string representation of a decimal number, using a `.` as the decimal separator.
     * @return $this
     */
    public function setNumberValue($number_value)
    {
        $this->number_value = $number_value;
        return $this;
    }
    /**
     * Gets boolean_value
     * @return bool
     */
    public function getBooleanValue()
    {
        return $this->boolean_value;
    }
  
    /**
     * Sets boolean_value
     * @param bool $boolean_value A `true` or `false` value. Populated if `type` = `BOOLEAN`.
     * @return $this
     */
    public function setBooleanValue($boolean_value)
    {
        $this->boolean_value = $boolean_value;
        return $this;
    }
    /**
     * Gets selection_uid_values
     * @return string[]
     */
    public function getSelectionUidValues()
    {
        return $this->selection_uid_values;
    }
  
    /**
     * Sets selection_uid_values
     * @param string[] $selection_uid_values One or more choices from `allowed_selections`. Populated if `type` = `SELECTION`.
     * @return $this
     */
    public function setSelectionUidValues($selection_uid_values)
    {
        $this->selection_uid_values = $selection_uid_values;
        return $this;
    }
    /**
     * Gets key
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
  
    /**
     * Sets key
     * @param string $key __Read-only.__ A copy of key from the associated `CatalogCustomAttributeDefinition`.
     * @return $this
     */
    public function setKey($key)
    {
        $this->key = $key;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
