<?php
/**
 * BrandingApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * BrandingApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BrandingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createBrandingSettings' => [
            'application/json',
        ],
        'createNameServerDomain' => [
            'application/json',
        ],
        'deleteBrandFavicon' => [
            'application/json',
        ],
        'deleteBrandInverseIcon' => [
            'application/json',
        ],
        'deleteBrandLoginImage' => [
            'application/json',
        ],
        'deleteBrandLogo' => [
            'application/json',
        ],
        'deleteBrandingSetting' => [
            'application/json',
        ],
        'deleteInverseBrandLogo' => [
            'application/json',
        ],
        'deleteNameServerDomain' => [
            'application/json',
        ],
        'getBranding' => [
            'application/json',
        ],
        'getBrandingSetting' => [
            'application/json',
        ],
        'getBrandingSettings' => [
            'application/json',
        ],
        'getStagingDomain' => [
            'application/json',
        ],
        'setBrandFavicon' => [
            'multipart/form-data',
        ],
        'setBrandInverseIcon' => [
            'multipart/form-data',
        ],
        'setBrandInverseLogo' => [
            'multipart/form-data',
        ],
        'setBrandLoginImage' => [
            'multipart/form-data',
        ],
        'setBrandLogo' => [
            'multipart/form-data',
        ],
        'setStagingDomain' => [
            'application/json',
        ],
        'updateBrandingSetting' => [
            'application/json',
        ],
        'updateNameServerDomain' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createBrandingSettings
     *
     * Create branding settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\Setting[] $setting setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrandingSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createBrandingSettings($org_id, $setting, string $contentType = self::contentTypes['createBrandingSettings'][0])
    {
        $this->createBrandingSettingsWithHttpInfo($org_id, $setting, $contentType);
    }

    /**
     * Operation createBrandingSettingsWithHttpInfo
     *
     * Create branding settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrandingSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandingSettingsWithHttpInfo($org_id, $setting, string $contentType = self::contentTypes['createBrandingSettings'][0])
    {
        $request = $this->createBrandingSettingsRequest($org_id, $setting, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createBrandingSettingsAsync
     *
     * Create branding settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrandingSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandingSettingsAsync($org_id, $setting, string $contentType = self::contentTypes['createBrandingSettings'][0])
    {
        return $this->createBrandingSettingsAsyncWithHttpInfo($org_id, $setting, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBrandingSettingsAsyncWithHttpInfo
     *
     * Create branding settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrandingSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandingSettingsAsyncWithHttpInfo($org_id, $setting, string $contentType = self::contentTypes['createBrandingSettings'][0])
    {
        $returnType = '';
        $request = $this->createBrandingSettingsRequest($org_id, $setting, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBrandingSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrandingSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBrandingSettingsRequest($org_id, $setting, string $contentType = self::contentTypes['createBrandingSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createBrandingSettings'
            );
        }

        // verify the required parameter 'setting' is set
        if ($setting === null || (is_array($setting) && count($setting) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting when calling createBrandingSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($setting)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($setting));
            } else {
                $httpBody = $setting;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createNameServerDomain
     *
     * Create reseller name server domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNameServerDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createNameServerDomain($org_id, $new_domain, string $contentType = self::contentTypes['createNameServerDomain'][0])
    {
        $this->createNameServerDomainWithHttpInfo($org_id, $new_domain, $contentType);
    }

    /**
     * Operation createNameServerDomainWithHttpInfo
     *
     * Create reseller name server domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNameServerDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createNameServerDomainWithHttpInfo($org_id, $new_domain, string $contentType = self::contentTypes['createNameServerDomain'][0])
    {
        $request = $this->createNameServerDomainRequest($org_id, $new_domain, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createNameServerDomainAsync
     *
     * Create reseller name server domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNameServerDomainAsync($org_id, $new_domain, string $contentType = self::contentTypes['createNameServerDomain'][0])
    {
        return $this->createNameServerDomainAsyncWithHttpInfo($org_id, $new_domain, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createNameServerDomainAsyncWithHttpInfo
     *
     * Create reseller name server domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNameServerDomainAsyncWithHttpInfo($org_id, $new_domain, string $contentType = self::contentTypes['createNameServerDomain'][0])
    {
        $returnType = '';
        $request = $this->createNameServerDomainRequest($org_id, $new_domain, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createNameServerDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createNameServerDomainRequest($org_id, $new_domain, string $contentType = self::contentTypes['createNameServerDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createNameServerDomain'
            );
        }

        // verify the required parameter 'new_domain' is set
        if ($new_domain === null || (is_array($new_domain) && count($new_domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_domain when calling createNameServerDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/name-servers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_domain)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_domain));
            } else {
                $httpBody = $new_domain;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBrandFavicon
     *
     * Delete brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandFavicon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBrandFavicon($org_id, string $contentType = self::contentTypes['deleteBrandFavicon'][0])
    {
        $this->deleteBrandFaviconWithHttpInfo($org_id, $contentType);
    }

    /**
     * Operation deleteBrandFaviconWithHttpInfo
     *
     * Delete brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandFavicon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandFaviconWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandFavicon'][0])
    {
        $request = $this->deleteBrandFaviconRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteBrandFaviconAsync
     *
     * Delete brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandFavicon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandFaviconAsync($org_id, string $contentType = self::contentTypes['deleteBrandFavicon'][0])
    {
        return $this->deleteBrandFaviconAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBrandFaviconAsyncWithHttpInfo
     *
     * Delete brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandFavicon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandFaviconAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandFavicon'][0])
    {
        $returnType = '';
        $request = $this->deleteBrandFaviconRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBrandFavicon'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandFavicon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBrandFaviconRequest($org_id, string $contentType = self::contentTypes['deleteBrandFavicon'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteBrandFavicon'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/favicon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBrandInverseIcon
     *
     * Delete brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBrandInverseIcon($org_id, string $contentType = self::contentTypes['deleteBrandInverseIcon'][0])
    {
        $this->deleteBrandInverseIconWithHttpInfo($org_id, $contentType);
    }

    /**
     * Operation deleteBrandInverseIconWithHttpInfo
     *
     * Delete brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandInverseIconWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandInverseIcon'][0])
    {
        $request = $this->deleteBrandInverseIconRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteBrandInverseIconAsync
     *
     * Delete brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandInverseIconAsync($org_id, string $contentType = self::contentTypes['deleteBrandInverseIcon'][0])
    {
        return $this->deleteBrandInverseIconAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBrandInverseIconAsyncWithHttpInfo
     *
     * Delete brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandInverseIconAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandInverseIcon'][0])
    {
        $returnType = '';
        $request = $this->deleteBrandInverseIconRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBrandInverseIcon'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBrandInverseIconRequest($org_id, string $contentType = self::contentTypes['deleteBrandInverseIcon'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteBrandInverseIcon'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/inverse-icon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBrandLoginImage
     *
     * Delete brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBrandLoginImage($org_id, string $contentType = self::contentTypes['deleteBrandLoginImage'][0])
    {
        $this->deleteBrandLoginImageWithHttpInfo($org_id, $contentType);
    }

    /**
     * Operation deleteBrandLoginImageWithHttpInfo
     *
     * Delete brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandLoginImageWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandLoginImage'][0])
    {
        $request = $this->deleteBrandLoginImageRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteBrandLoginImageAsync
     *
     * Delete brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandLoginImageAsync($org_id, string $contentType = self::contentTypes['deleteBrandLoginImage'][0])
    {
        return $this->deleteBrandLoginImageAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBrandLoginImageAsyncWithHttpInfo
     *
     * Delete brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandLoginImageAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandLoginImage'][0])
    {
        $returnType = '';
        $request = $this->deleteBrandLoginImageRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBrandLoginImage'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBrandLoginImageRequest($org_id, string $contentType = self::contentTypes['deleteBrandLoginImage'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteBrandLoginImage'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/login-image';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBrandLogo
     *
     * Delete brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBrandLogo($org_id, string $contentType = self::contentTypes['deleteBrandLogo'][0])
    {
        $this->deleteBrandLogoWithHttpInfo($org_id, $contentType);
    }

    /**
     * Operation deleteBrandLogoWithHttpInfo
     *
     * Delete brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandLogoWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandLogo'][0])
    {
        $request = $this->deleteBrandLogoRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteBrandLogoAsync
     *
     * Delete brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandLogoAsync($org_id, string $contentType = self::contentTypes['deleteBrandLogo'][0])
    {
        return $this->deleteBrandLogoAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBrandLogoAsyncWithHttpInfo
     *
     * Delete brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandLogoAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteBrandLogo'][0])
    {
        $returnType = '';
        $request = $this->deleteBrandLogoRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBrandLogo'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBrandLogoRequest($org_id, string $contentType = self::contentTypes['deleteBrandLogo'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteBrandLogo'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/logo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBrandingSetting
     *
     * Remove the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandingSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBrandingSetting($org_id, $name, string $contentType = self::contentTypes['deleteBrandingSetting'][0])
    {
        $this->deleteBrandingSettingWithHttpInfo($org_id, $name, $contentType);
    }

    /**
     * Operation deleteBrandingSettingWithHttpInfo
     *
     * Remove the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandingSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandingSettingWithHttpInfo($org_id, $name, string $contentType = self::contentTypes['deleteBrandingSetting'][0])
    {
        $request = $this->deleteBrandingSettingRequest($org_id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteBrandingSettingAsync
     *
     * Remove the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandingSettingAsync($org_id, $name, string $contentType = self::contentTypes['deleteBrandingSetting'][0])
    {
        return $this->deleteBrandingSettingAsyncWithHttpInfo($org_id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBrandingSettingAsyncWithHttpInfo
     *
     * Remove the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBrandingSettingAsyncWithHttpInfo($org_id, $name, string $contentType = self::contentTypes['deleteBrandingSetting'][0])
    {
        $returnType = '';
        $request = $this->deleteBrandingSettingRequest($org_id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBrandingSetting'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBrandingSettingRequest($org_id, $name, string $contentType = self::contentTypes['deleteBrandingSetting'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteBrandingSetting'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling deleteBrandingSetting'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInverseBrandLogo
     *
     * Delete brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInverseBrandLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInverseBrandLogo($org_id, string $contentType = self::contentTypes['deleteInverseBrandLogo'][0])
    {
        $this->deleteInverseBrandLogoWithHttpInfo($org_id, $contentType);
    }

    /**
     * Operation deleteInverseBrandLogoWithHttpInfo
     *
     * Delete brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInverseBrandLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInverseBrandLogoWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteInverseBrandLogo'][0])
    {
        $request = $this->deleteInverseBrandLogoRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteInverseBrandLogoAsync
     *
     * Delete brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInverseBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInverseBrandLogoAsync($org_id, string $contentType = self::contentTypes['deleteInverseBrandLogo'][0])
    {
        return $this->deleteInverseBrandLogoAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInverseBrandLogoAsyncWithHttpInfo
     *
     * Delete brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInverseBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInverseBrandLogoAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['deleteInverseBrandLogo'][0])
    {
        $returnType = '';
        $request = $this->deleteInverseBrandLogoRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInverseBrandLogo'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInverseBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInverseBrandLogoRequest($org_id, string $contentType = self::contentTypes['deleteInverseBrandLogo'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteInverseBrandLogo'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/inverse-logo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteNameServerDomain
     *
     * Delete reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteNameServerDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteNameServerDomain($org_id, $domain, string $contentType = self::contentTypes['deleteNameServerDomain'][0])
    {
        $this->deleteNameServerDomainWithHttpInfo($org_id, $domain, $contentType);
    }

    /**
     * Operation deleteNameServerDomainWithHttpInfo
     *
     * Delete reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteNameServerDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteNameServerDomainWithHttpInfo($org_id, $domain, string $contentType = self::contentTypes['deleteNameServerDomain'][0])
    {
        $request = $this->deleteNameServerDomainRequest($org_id, $domain, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteNameServerDomainAsync
     *
     * Delete reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteNameServerDomainAsync($org_id, $domain, string $contentType = self::contentTypes['deleteNameServerDomain'][0])
    {
        return $this->deleteNameServerDomainAsyncWithHttpInfo($org_id, $domain, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteNameServerDomainAsyncWithHttpInfo
     *
     * Delete reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteNameServerDomainAsyncWithHttpInfo($org_id, $domain, string $contentType = self::contentTypes['deleteNameServerDomain'][0])
    {
        $returnType = '';
        $request = $this->deleteNameServerDomainRequest($org_id, $domain, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteNameServerDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteNameServerDomainRequest($org_id, $domain, string $contentType = self::contentTypes['deleteNameServerDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteNameServerDomain'
            );
        }

        // verify the required parameter 'domain' is set
        if ($domain === null || (is_array($domain) && count($domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain when calling deleteNameServerDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/name-servers/{domain}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain !== null) {
            $resourcePath = str_replace(
                '{' . 'domain' . '}',
                ObjectSerializer::toPathValue($domain),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBranding
     *
     * Get default branding
     *
     * @param  string|null $org_id The id of the currently logged in organization. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBranding'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Branding
     */
    public function getBranding($org_id = null, string $contentType = self::contentTypes['getBranding'][0])
    {
        list($response) = $this->getBrandingWithHttpInfo($org_id, $contentType);
        return $response;
    }

    /**
     * Operation getBrandingWithHttpInfo
     *
     * Get default branding
     *
     * @param  string|null $org_id The id of the currently logged in organization. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBranding'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Branding, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandingWithHttpInfo($org_id = null, string $contentType = self::contentTypes['getBranding'][0])
    {
        $request = $this->getBrandingRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Branding',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Branding',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Branding',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getBrandingAsync
     *
     * Get default branding
     *
     * @param  string|null $org_id The id of the currently logged in organization. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBranding'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandingAsync($org_id = null, string $contentType = self::contentTypes['getBranding'][0])
    {
        return $this->getBrandingAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBrandingAsyncWithHttpInfo
     *
     * Get default branding
     *
     * @param  string|null $org_id The id of the currently logged in organization. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBranding'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandingAsyncWithHttpInfo($org_id = null, string $contentType = self::contentTypes['getBranding'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Branding';
        $request = $this->getBrandingRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBranding'
     *
     * @param  string|null $org_id The id of the currently logged in organization. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBranding'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBrandingRequest($org_id = null, string $contentType = self::contentTypes['getBranding'][0])
    {



        $resourcePath = '/branding';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $org_id,
            'orgId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBrandingSetting
     *
     * Get the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Setting
     */
    public function getBrandingSetting($org_id, $name, string $contentType = self::contentTypes['getBrandingSetting'][0])
    {
        list($response) = $this->getBrandingSettingWithHttpInfo($org_id, $name, $contentType);
        return $response;
    }

    /**
     * Operation getBrandingSettingWithHttpInfo
     *
     * Get the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Setting, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandingSettingWithHttpInfo($org_id, $name, string $contentType = self::contentTypes['getBrandingSetting'][0])
    {
        $request = $this->getBrandingSettingRequest($org_id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Setting',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Setting',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Setting',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getBrandingSettingAsync
     *
     * Get the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandingSettingAsync($org_id, $name, string $contentType = self::contentTypes['getBrandingSetting'][0])
    {
        return $this->getBrandingSettingAsyncWithHttpInfo($org_id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBrandingSettingAsyncWithHttpInfo
     *
     * Get the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandingSettingAsyncWithHttpInfo($org_id, $name, string $contentType = self::contentTypes['getBrandingSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Setting';
        $request = $this->getBrandingSettingRequest($org_id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBrandingSetting'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBrandingSettingRequest($org_id, $name, string $contentType = self::contentTypes['getBrandingSetting'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getBrandingSetting'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getBrandingSetting'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBrandingSettings
     *
     * Get all current settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SettingsFullListing
     */
    public function getBrandingSettings($org_id, string $contentType = self::contentTypes['getBrandingSettings'][0])
    {
        list($response) = $this->getBrandingSettingsWithHttpInfo($org_id, $contentType);
        return $response;
    }

    /**
     * Operation getBrandingSettingsWithHttpInfo
     *
     * Get all current settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SettingsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandingSettingsWithHttpInfo($org_id, string $contentType = self::contentTypes['getBrandingSettings'][0])
    {
        $request = $this->getBrandingSettingsRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SettingsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SettingsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SettingsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getBrandingSettingsAsync
     *
     * Get all current settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandingSettingsAsync($org_id, string $contentType = self::contentTypes['getBrandingSettings'][0])
    {
        return $this->getBrandingSettingsAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBrandingSettingsAsyncWithHttpInfo
     *
     * Get all current settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandingSettingsAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['getBrandingSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SettingsFullListing';
        $request = $this->getBrandingSettingsRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBrandingSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrandingSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBrandingSettingsRequest($org_id, string $contentType = self::contentTypes['getBrandingSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getBrandingSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStagingDomain
     *
     * Fetches the staging domain which is currently set
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStagingDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\StagingDomain
     */
    public function getStagingDomain($org_id, string $contentType = self::contentTypes['getStagingDomain'][0])
    {
        list($response) = $this->getStagingDomainWithHttpInfo($org_id, $contentType);
        return $response;
    }

    /**
     * Operation getStagingDomainWithHttpInfo
     *
     * Fetches the staging domain which is currently set
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStagingDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\StagingDomain, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStagingDomainWithHttpInfo($org_id, string $contentType = self::contentTypes['getStagingDomain'][0])
    {
        $request = $this->getStagingDomainRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\StagingDomain',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\StagingDomain',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\StagingDomain',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getStagingDomainAsync
     *
     * Fetches the staging domain which is currently set
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStagingDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStagingDomainAsync($org_id, string $contentType = self::contentTypes['getStagingDomain'][0])
    {
        return $this->getStagingDomainAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStagingDomainAsyncWithHttpInfo
     *
     * Fetches the staging domain which is currently set
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStagingDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStagingDomainAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['getStagingDomain'][0])
    {
        $returnType = '\OpenAPI\Client\Model\StagingDomain';
        $request = $this->getStagingDomainRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStagingDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStagingDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStagingDomainRequest($org_id, string $contentType = self::contentTypes['getStagingDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getStagingDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/staging-domain';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setBrandFavicon
     *
     * Set brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $favicon favicon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandFavicon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setBrandFavicon($org_id, $favicon = null, string $contentType = self::contentTypes['setBrandFavicon'][0])
    {
        $this->setBrandFaviconWithHttpInfo($org_id, $favicon, $contentType);
    }

    /**
     * Operation setBrandFaviconWithHttpInfo
     *
     * Set brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $favicon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandFavicon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setBrandFaviconWithHttpInfo($org_id, $favicon = null, string $contentType = self::contentTypes['setBrandFavicon'][0])
    {
        $request = $this->setBrandFaviconRequest($org_id, $favicon, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setBrandFaviconAsync
     *
     * Set brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $favicon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandFavicon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandFaviconAsync($org_id, $favicon = null, string $contentType = self::contentTypes['setBrandFavicon'][0])
    {
        return $this->setBrandFaviconAsyncWithHttpInfo($org_id, $favicon, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setBrandFaviconAsyncWithHttpInfo
     *
     * Set brand favicon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $favicon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandFavicon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandFaviconAsyncWithHttpInfo($org_id, $favicon = null, string $contentType = self::contentTypes['setBrandFavicon'][0])
    {
        $returnType = '';
        $request = $this->setBrandFaviconRequest($org_id, $favicon, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setBrandFavicon'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $favicon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandFavicon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setBrandFaviconRequest($org_id, $favicon = null, string $contentType = self::contentTypes['setBrandFavicon'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setBrandFavicon'
            );
        }



        $resourcePath = '/orgs/{org_id}/branding/favicon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'favicon' => $favicon,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setBrandInverseIcon
     *
     * Set brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $icon icon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setBrandInverseIcon($org_id, $icon = null, string $contentType = self::contentTypes['setBrandInverseIcon'][0])
    {
        $this->setBrandInverseIconWithHttpInfo($org_id, $icon, $contentType);
    }

    /**
     * Operation setBrandInverseIconWithHttpInfo
     *
     * Set brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $icon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setBrandInverseIconWithHttpInfo($org_id, $icon = null, string $contentType = self::contentTypes['setBrandInverseIcon'][0])
    {
        $request = $this->setBrandInverseIconRequest($org_id, $icon, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setBrandInverseIconAsync
     *
     * Set brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $icon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandInverseIconAsync($org_id, $icon = null, string $contentType = self::contentTypes['setBrandInverseIcon'][0])
    {
        return $this->setBrandInverseIconAsyncWithHttpInfo($org_id, $icon, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setBrandInverseIconAsyncWithHttpInfo
     *
     * Set brand inverse icon
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $icon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandInverseIconAsyncWithHttpInfo($org_id, $icon = null, string $contentType = self::contentTypes['setBrandInverseIcon'][0])
    {
        $returnType = '';
        $request = $this->setBrandInverseIconRequest($org_id, $icon, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setBrandInverseIcon'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $icon (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseIcon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setBrandInverseIconRequest($org_id, $icon = null, string $contentType = self::contentTypes['setBrandInverseIcon'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setBrandInverseIcon'
            );
        }



        $resourcePath = '/orgs/{org_id}/branding/inverse-icon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'icon' => $icon,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setBrandInverseLogo
     *
     * Set brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setBrandInverseLogo($org_id, $logo = null, string $contentType = self::contentTypes['setBrandInverseLogo'][0])
    {
        $this->setBrandInverseLogoWithHttpInfo($org_id, $logo, $contentType);
    }

    /**
     * Operation setBrandInverseLogoWithHttpInfo
     *
     * Set brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setBrandInverseLogoWithHttpInfo($org_id, $logo = null, string $contentType = self::contentTypes['setBrandInverseLogo'][0])
    {
        $request = $this->setBrandInverseLogoRequest($org_id, $logo, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setBrandInverseLogoAsync
     *
     * Set brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandInverseLogoAsync($org_id, $logo = null, string $contentType = self::contentTypes['setBrandInverseLogo'][0])
    {
        return $this->setBrandInverseLogoAsyncWithHttpInfo($org_id, $logo, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setBrandInverseLogoAsyncWithHttpInfo
     *
     * Set brand inverse logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandInverseLogoAsyncWithHttpInfo($org_id, $logo = null, string $contentType = self::contentTypes['setBrandInverseLogo'][0])
    {
        $returnType = '';
        $request = $this->setBrandInverseLogoRequest($org_id, $logo, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setBrandInverseLogo'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandInverseLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setBrandInverseLogoRequest($org_id, $logo = null, string $contentType = self::contentTypes['setBrandInverseLogo'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setBrandInverseLogo'
            );
        }



        $resourcePath = '/orgs/{org_id}/branding/inverse-logo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'logo' => $logo,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setBrandLoginImage
     *
     * Set brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $login_image login_image (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setBrandLoginImage($org_id, $login_image = null, string $contentType = self::contentTypes['setBrandLoginImage'][0])
    {
        $this->setBrandLoginImageWithHttpInfo($org_id, $login_image, $contentType);
    }

    /**
     * Operation setBrandLoginImageWithHttpInfo
     *
     * Set brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $login_image (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setBrandLoginImageWithHttpInfo($org_id, $login_image = null, string $contentType = self::contentTypes['setBrandLoginImage'][0])
    {
        $request = $this->setBrandLoginImageRequest($org_id, $login_image, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setBrandLoginImageAsync
     *
     * Set brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $login_image (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandLoginImageAsync($org_id, $login_image = null, string $contentType = self::contentTypes['setBrandLoginImage'][0])
    {
        return $this->setBrandLoginImageAsyncWithHttpInfo($org_id, $login_image, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setBrandLoginImageAsyncWithHttpInfo
     *
     * Set brand login image
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $login_image (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandLoginImageAsyncWithHttpInfo($org_id, $login_image = null, string $contentType = self::contentTypes['setBrandLoginImage'][0])
    {
        $returnType = '';
        $request = $this->setBrandLoginImageRequest($org_id, $login_image, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setBrandLoginImage'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $login_image (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLoginImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setBrandLoginImageRequest($org_id, $login_image = null, string $contentType = self::contentTypes['setBrandLoginImage'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setBrandLoginImage'
            );
        }



        $resourcePath = '/orgs/{org_id}/branding/login-image';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'login_image' => $login_image,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setBrandLogo
     *
     * Set brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setBrandLogo($org_id, $logo = null, string $contentType = self::contentTypes['setBrandLogo'][0])
    {
        $this->setBrandLogoWithHttpInfo($org_id, $logo, $contentType);
    }

    /**
     * Operation setBrandLogoWithHttpInfo
     *
     * Set brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLogo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setBrandLogoWithHttpInfo($org_id, $logo = null, string $contentType = self::contentTypes['setBrandLogo'][0])
    {
        $request = $this->setBrandLogoRequest($org_id, $logo, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setBrandLogoAsync
     *
     * Set brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandLogoAsync($org_id, $logo = null, string $contentType = self::contentTypes['setBrandLogo'][0])
    {
        return $this->setBrandLogoAsyncWithHttpInfo($org_id, $logo, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setBrandLogoAsyncWithHttpInfo
     *
     * Set brand logo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setBrandLogoAsyncWithHttpInfo($org_id, $logo = null, string $contentType = self::contentTypes['setBrandLogo'][0])
    {
        $returnType = '';
        $request = $this->setBrandLogoRequest($org_id, $logo, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setBrandLogo'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \SplFileObject|null $logo (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setBrandLogo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setBrandLogoRequest($org_id, $logo = null, string $contentType = self::contentTypes['setBrandLogo'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setBrandLogo'
            );
        }



        $resourcePath = '/orgs/{org_id}/branding/logo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'logo' => $logo,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setStagingDomain
     *
     * Set or update domain suffix for staging websites created by customers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\StagingDomain $staging_domain staging_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStagingDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setStagingDomain($org_id, $staging_domain, string $contentType = self::contentTypes['setStagingDomain'][0])
    {
        $this->setStagingDomainWithHttpInfo($org_id, $staging_domain, $contentType);
    }

    /**
     * Operation setStagingDomainWithHttpInfo
     *
     * Set or update domain suffix for staging websites created by customers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\StagingDomain $staging_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStagingDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setStagingDomainWithHttpInfo($org_id, $staging_domain, string $contentType = self::contentTypes['setStagingDomain'][0])
    {
        $request = $this->setStagingDomainRequest($org_id, $staging_domain, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setStagingDomainAsync
     *
     * Set or update domain suffix for staging websites created by customers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\StagingDomain $staging_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStagingDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setStagingDomainAsync($org_id, $staging_domain, string $contentType = self::contentTypes['setStagingDomain'][0])
    {
        return $this->setStagingDomainAsyncWithHttpInfo($org_id, $staging_domain, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setStagingDomainAsyncWithHttpInfo
     *
     * Set or update domain suffix for staging websites created by customers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\StagingDomain $staging_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStagingDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setStagingDomainAsyncWithHttpInfo($org_id, $staging_domain, string $contentType = self::contentTypes['setStagingDomain'][0])
    {
        $returnType = '';
        $request = $this->setStagingDomainRequest($org_id, $staging_domain, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setStagingDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\StagingDomain $staging_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStagingDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setStagingDomainRequest($org_id, $staging_domain, string $contentType = self::contentTypes['setStagingDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setStagingDomain'
            );
        }

        // verify the required parameter 'staging_domain' is set
        if ($staging_domain === null || (is_array($staging_domain) && count($staging_domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $staging_domain when calling setStagingDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/staging-domain';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($staging_domain)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($staging_domain));
            } else {
                $httpBody = $staging_domain;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateBrandingSetting
     *
     * Create or update the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBrandingSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateBrandingSetting($org_id, $name, $body, string $contentType = self::contentTypes['updateBrandingSetting'][0])
    {
        $this->updateBrandingSettingWithHttpInfo($org_id, $name, $body, $contentType);
    }

    /**
     * Operation updateBrandingSettingWithHttpInfo
     *
     * Create or update the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBrandingSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandingSettingWithHttpInfo($org_id, $name, $body, string $contentType = self::contentTypes['updateBrandingSetting'][0])
    {
        $request = $this->updateBrandingSettingRequest($org_id, $name, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateBrandingSettingAsync
     *
     * Create or update the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBrandingSettingAsync($org_id, $name, $body, string $contentType = self::contentTypes['updateBrandingSetting'][0])
    {
        return $this->updateBrandingSettingAsyncWithHttpInfo($org_id, $name, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateBrandingSettingAsyncWithHttpInfo
     *
     * Create or update the specified setting
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBrandingSettingAsyncWithHttpInfo($org_id, $name, $body, string $contentType = self::contentTypes['updateBrandingSetting'][0])
    {
        $returnType = '';
        $request = $this->updateBrandingSettingRequest($org_id, $name, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateBrandingSetting'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $name The name of the resource. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBrandingSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateBrandingSettingRequest($org_id, $name, $body, string $contentType = self::contentTypes['updateBrandingSetting'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateBrandingSetting'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updateBrandingSetting'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateBrandingSetting'
            );
        }


        $resourcePath = '/orgs/{org_id}/branding/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateNameServerDomain
     *
     * Update reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateNameServerDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateNameServerDomain($org_id, $domain, $new_domain, string $contentType = self::contentTypes['updateNameServerDomain'][0])
    {
        $this->updateNameServerDomainWithHttpInfo($org_id, $domain, $new_domain, $contentType);
    }

    /**
     * Operation updateNameServerDomainWithHttpInfo
     *
     * Update reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateNameServerDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNameServerDomainWithHttpInfo($org_id, $domain, $new_domain, string $contentType = self::contentTypes['updateNameServerDomain'][0])
    {
        $request = $this->updateNameServerDomainRequest($org_id, $domain, $new_domain, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateNameServerDomainAsync
     *
     * Update reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateNameServerDomainAsync($org_id, $domain, $new_domain, string $contentType = self::contentTypes['updateNameServerDomain'][0])
    {
        return $this->updateNameServerDomainAsyncWithHttpInfo($org_id, $domain, $new_domain, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateNameServerDomainAsyncWithHttpInfo
     *
     * Update reseller name server domain name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateNameServerDomainAsyncWithHttpInfo($org_id, $domain, $new_domain, string $contentType = self::contentTypes['updateNameServerDomain'][0])
    {
        $returnType = '';
        $request = $this->updateNameServerDomainRequest($org_id, $domain, $new_domain, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateNameServerDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain The domain name. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateNameServerDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateNameServerDomainRequest($org_id, $domain, $new_domain, string $contentType = self::contentTypes['updateNameServerDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateNameServerDomain'
            );
        }

        // verify the required parameter 'domain' is set
        if ($domain === null || (is_array($domain) && count($domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain when calling updateNameServerDomain'
            );
        }

        // verify the required parameter 'new_domain' is set
        if ($new_domain === null || (is_array($new_domain) && count($new_domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_domain when calling updateNameServerDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/name-servers/{domain}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain !== null) {
            $resourcePath = str_replace(
                '{' . 'domain' . '}',
                ObjectSerializer::toPathValue($domain),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_domain)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_domain));
            } else {
                $httpBody = $new_domain;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
