<?php
/**
 * SettingsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * SettingsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SettingsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addOrchdLoginPolicyEmailBlacklist' => [
            'application/json',
        ],
        'addOrchdLoginPolicyEmailWhitelist' => [
            'application/json',
        ],
        'addOrchdLoginPolicyIpBlacklist' => [
            'application/json',
        ],
        'addOrchdLoginPolicyIpWhitelist' => [
            'application/json',
        ],
        'addOrchdLoginPolicySettings' => [
            'application/json',
        ],
        'createBackupRemoteStorageS3' => [
            'application/json',
        ],
        'createSettings' => [
            'application/json',
        ],
        'deleteBackupRemoteStorageS3' => [
            'application/json',
        ],
        'deleteGlobalServiceSetting' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyEmailBlacklist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyEmailWhitelist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyIpBlacklist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyIpWhitelist' => [
            'application/json',
        ],
        'deleteSetting' => [
            'application/json',
        ],
        'getAdminLockdownList' => [
            'application/json',
        ],
        'getAdminLockdownStatus' => [
            'application/json',
        ],
        'getBackupRemoteStorageS3' => [
            'application/json',
        ],
        'getDemoMode' => [
            'application/json',
        ],
        'getGlobalServiceSetting' => [
            'application/json',
        ],
        'getOrchdLogSettings' => [
            'application/json',
        ],
        'getOrchdLoginPolicyEmailBlacklist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyEmailWhitelist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyIpBlacklist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyIpWhitelist' => [
            'application/json',
        ],
        'getOrchdLoginPolicySettings' => [
            'application/json',
        ],
        'getProhibitedDomains' => [
            'application/json',
        ],
        'getSetting' => [
            'application/json',
        ],
        'getSettings' => [
            'application/json',
        ],
        'setAdminLockdownList' => [
            'application/json',
        ],
        'setAdminLockdownStatus' => [
            'application/json',
        ],
        'setGlobalServiceSetting' => [
            'application/json',
        ],
        'setOrchdLogSettings' => [
            'application/json',
        ],
        'setProhibitedDomains' => [
            'application/json',
        ],
        'updateBackupRemoteStorageS3' => [
            'application/json',
        ],
        'updateSetting' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addOrchdLoginPolicyEmailBlacklist
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addOrchdLoginPolicyEmailBlacklist($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailBlacklist'][0])
    {
        $this->addOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation addOrchdLoginPolicyEmailBlacklistWithHttpInfo
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailBlacklist'][0])
    {
        $request = $this->addOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addOrchdLoginPolicyEmailBlacklistAsync
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyEmailBlacklistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailBlacklist'][0])
    {
        return $this->addOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailBlacklist'][0])
    {
        $returnType = '';
        $request = $this->addOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrchdLoginPolicyEmailBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling addOrchdLoginPolicyEmailBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addOrchdLoginPolicyEmailWhitelist
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addOrchdLoginPolicyEmailWhitelist($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailWhitelist'][0])
    {
        $this->addOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation addOrchdLoginPolicyEmailWhitelistWithHttpInfo
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailWhitelist'][0])
    {
        $request = $this->addOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addOrchdLoginPolicyEmailWhitelistAsync
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyEmailWhitelistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailWhitelist'][0])
    {
        return $this->addOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailWhitelist'][0])
    {
        $returnType = '';
        $request = $this->addOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrchdLoginPolicyEmailWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['addOrchdLoginPolicyEmailWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling addOrchdLoginPolicyEmailWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addOrchdLoginPolicyIpBlacklist
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addOrchdLoginPolicyIpBlacklist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpBlacklist'][0])
    {
        $this->addOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation addOrchdLoginPolicyIpBlacklistWithHttpInfo
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpBlacklist'][0])
    {
        $request = $this->addOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addOrchdLoginPolicyIpBlacklistAsync
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyIpBlacklistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpBlacklist'][0])
    {
        return $this->addOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpBlacklist'][0])
    {
        $returnType = '';
        $request = $this->addOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrchdLoginPolicyIpBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling addOrchdLoginPolicyIpBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addOrchdLoginPolicyIpWhitelist
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addOrchdLoginPolicyIpWhitelist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpWhitelist'][0])
    {
        $this->addOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation addOrchdLoginPolicyIpWhitelistWithHttpInfo
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpWhitelist'][0])
    {
        $request = $this->addOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addOrchdLoginPolicyIpWhitelistAsync
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyIpWhitelistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpWhitelist'][0])
    {
        return $this->addOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpWhitelist'][0])
    {
        $returnType = '';
        $request = $this->addOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrchdLoginPolicyIpWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['addOrchdLoginPolicyIpWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling addOrchdLoginPolicyIpWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addOrchdLoginPolicySettings
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addOrchdLoginPolicySettings($orchd_login_policy_settings, string $contentType = self::contentTypes['addOrchdLoginPolicySettings'][0])
    {
        $this->addOrchdLoginPolicySettingsWithHttpInfo($orchd_login_policy_settings, $contentType);
    }

    /**
     * Operation addOrchdLoginPolicySettingsWithHttpInfo
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrchdLoginPolicySettingsWithHttpInfo($orchd_login_policy_settings, string $contentType = self::contentTypes['addOrchdLoginPolicySettings'][0])
    {
        $request = $this->addOrchdLoginPolicySettingsRequest($orchd_login_policy_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addOrchdLoginPolicySettingsAsync
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicySettingsAsync($orchd_login_policy_settings, string $contentType = self::contentTypes['addOrchdLoginPolicySettings'][0])
    {
        return $this->addOrchdLoginPolicySettingsAsyncWithHttpInfo($orchd_login_policy_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrchdLoginPolicySettingsAsyncWithHttpInfo
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrchdLoginPolicySettingsAsyncWithHttpInfo($orchd_login_policy_settings, string $contentType = self::contentTypes['addOrchdLoginPolicySettings'][0])
    {
        $returnType = '';
        $request = $this->addOrchdLoginPolicySettingsRequest($orchd_login_policy_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrchdLoginPolicySettings'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrchdLoginPolicySettingsRequest($orchd_login_policy_settings, string $contentType = self::contentTypes['addOrchdLoginPolicySettings'][0])
    {

        // verify the required parameter 'orchd_login_policy_settings' is set
        if ($orchd_login_policy_settings === null || (is_array($orchd_login_policy_settings) && count($orchd_login_policy_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_settings when calling addOrchdLoginPolicySettings'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_settings));
            } else {
                $httpBody = $orchd_login_policy_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBackupRemoteStorageS3
     *
     * Create S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\CreateBackupRemoteStorageS3 $create_backup_remote_storage_s3 create_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createBackupRemoteStorageS3($create_backup_remote_storage_s3, string $contentType = self::contentTypes['createBackupRemoteStorageS3'][0])
    {
        $this->createBackupRemoteStorageS3WithHttpInfo($create_backup_remote_storage_s3, $contentType);
    }

    /**
     * Operation createBackupRemoteStorageS3WithHttpInfo
     *
     * Create S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\CreateBackupRemoteStorageS3 $create_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBackupRemoteStorageS3WithHttpInfo($create_backup_remote_storage_s3, string $contentType = self::contentTypes['createBackupRemoteStorageS3'][0])
    {
        $request = $this->createBackupRemoteStorageS3Request($create_backup_remote_storage_s3, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createBackupRemoteStorageS3Async
     *
     * Create S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\CreateBackupRemoteStorageS3 $create_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBackupRemoteStorageS3Async($create_backup_remote_storage_s3, string $contentType = self::contentTypes['createBackupRemoteStorageS3'][0])
    {
        return $this->createBackupRemoteStorageS3AsyncWithHttpInfo($create_backup_remote_storage_s3, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBackupRemoteStorageS3AsyncWithHttpInfo
     *
     * Create S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\CreateBackupRemoteStorageS3 $create_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBackupRemoteStorageS3AsyncWithHttpInfo($create_backup_remote_storage_s3, string $contentType = self::contentTypes['createBackupRemoteStorageS3'][0])
    {
        $returnType = '';
        $request = $this->createBackupRemoteStorageS3Request($create_backup_remote_storage_s3, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBackupRemoteStorageS3'
     *
     * @param  \OpenAPI\Client\Model\CreateBackupRemoteStorageS3 $create_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBackupRemoteStorageS3Request($create_backup_remote_storage_s3, string $contentType = self::contentTypes['createBackupRemoteStorageS3'][0])
    {

        // verify the required parameter 'create_backup_remote_storage_s3' is set
        if ($create_backup_remote_storage_s3 === null || (is_array($create_backup_remote_storage_s3) && count($create_backup_remote_storage_s3) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_backup_remote_storage_s3 when calling createBackupRemoteStorageS3'
            );
        }


        $resourcePath = '/v2/settings/backup/remote_storage/s3';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_backup_remote_storage_s3)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_backup_remote_storage_s3));
            } else {
                $httpBody = $create_backup_remote_storage_s3;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSettings
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createSettings($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        $this->createSettingsWithHttpInfo($setting, $contentType);
    }

    /**
     * Operation createSettingsWithHttpInfo
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSettingsWithHttpInfo($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        $request = $this->createSettingsRequest($setting, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createSettingsAsync
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSettingsAsync($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        return $this->createSettingsAsyncWithHttpInfo($setting, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSettingsAsyncWithHttpInfo
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSettingsAsyncWithHttpInfo($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        $returnType = '';
        $request = $this->createSettingsRequest($setting, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSettings'
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSettingsRequest($setting, string $contentType = self::contentTypes['createSettings'][0])
    {

        // verify the required parameter 'setting' is set
        if ($setting === null || (is_array($setting) && count($setting) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting when calling createSettings'
            );
        }


        $resourcePath = '/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($setting)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($setting));
            } else {
                $httpBody = $setting;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBackupRemoteStorageS3
     *
     * Delete S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBackupRemoteStorageS3(string $contentType = self::contentTypes['deleteBackupRemoteStorageS3'][0])
    {
        $this->deleteBackupRemoteStorageS3WithHttpInfo($contentType);
    }

    /**
     * Operation deleteBackupRemoteStorageS3WithHttpInfo
     *
     * Delete S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBackupRemoteStorageS3WithHttpInfo(string $contentType = self::contentTypes['deleteBackupRemoteStorageS3'][0])
    {
        $request = $this->deleteBackupRemoteStorageS3Request($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteBackupRemoteStorageS3Async
     *
     * Delete S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBackupRemoteStorageS3Async(string $contentType = self::contentTypes['deleteBackupRemoteStorageS3'][0])
    {
        return $this->deleteBackupRemoteStorageS3AsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBackupRemoteStorageS3AsyncWithHttpInfo
     *
     * Delete S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBackupRemoteStorageS3AsyncWithHttpInfo(string $contentType = self::contentTypes['deleteBackupRemoteStorageS3'][0])
    {
        $returnType = '';
        $request = $this->deleteBackupRemoteStorageS3Request($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBackupRemoteStorageS3'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBackupRemoteStorageS3Request(string $contentType = self::contentTypes['deleteBackupRemoteStorageS3'][0])
    {


        $resourcePath = '/v2/settings/backup/remote_storage/s3';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGlobalServiceSetting
     *
     * Delete a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome
     */
    public function deleteGlobalServiceSetting($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        list($response) = $this->deleteGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, $contentType);
        return $response;
    }

    /**
     * Operation deleteGlobalServiceSettingWithHttpInfo
     *
     * Delete a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        $request = $this->deleteGlobalServiceSettingRequest($setting_kind, $setting_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Outcome',
                        $request,
                        $response,
                    );
                case 202:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Outcome',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Outcome',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteGlobalServiceSettingAsync
     *
     * Delete a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGlobalServiceSettingAsync($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        return $this->deleteGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGlobalServiceSettingAsyncWithHttpInfo
     *
     * Delete a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Outcome';
        $request = $this->deleteGlobalServiceSettingRequest($setting_kind, $setting_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGlobalServiceSetting'
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGlobalServiceSettingRequest($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {

        // verify the required parameter 'setting_kind' is set
        if ($setting_kind === null || (is_array($setting_kind) && count($setting_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_kind when calling deleteGlobalServiceSetting'
            );
        }

        // verify the required parameter 'setting_key' is set
        if ($setting_key === null || (is_array($setting_key) && count($setting_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_key when calling deleteGlobalServiceSetting'
            );
        }


        $resourcePath = '/settings/service/{setting_kind}/{setting_key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($setting_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_kind' . '}',
                ObjectSerializer::toPathValue($setting_kind),
                $resourcePath
            );
        }
        // path params
        if ($setting_key !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_key' . '}',
                ObjectSerializer::toPathValue($setting_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklist
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyEmailBlacklist($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        $this->deleteOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklistWithHttpInfo
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklistAsync
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailBlacklistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        return $this->deleteOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyEmailBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling deleteOrchdLoginPolicyEmailBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelist
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyEmailWhitelist($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        $this->deleteOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelistWithHttpInfo
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelistAsync
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailWhitelistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        return $this->deleteOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyEmailWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling deleteOrchdLoginPolicyEmailWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklist
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyIpBlacklist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        $this->deleteOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklistWithHttpInfo
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklistAsync
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpBlacklistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        return $this->deleteOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyIpBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling deleteOrchdLoginPolicyIpBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelist
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyIpWhitelist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        $this->deleteOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelistWithHttpInfo
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelistAsync
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpWhitelistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        return $this->deleteOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyIpWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling deleteOrchdLoginPolicyIpWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSetting
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSetting($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        $this->deleteSettingWithHttpInfo($name, $contentType);
    }

    /**
     * Operation deleteSettingWithHttpInfo
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSettingWithHttpInfo($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        $request = $this->deleteSettingRequest($name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSettingAsync
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSettingAsync($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        return $this->deleteSettingAsyncWithHttpInfo($name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSettingAsyncWithHttpInfo
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSettingAsyncWithHttpInfo($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        $returnType = '';
        $request = $this->deleteSettingRequest($name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSetting'
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSettingRequest($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling deleteSetting'
            );
        }


        $resourcePath = '/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAdminLockdownList
     *
     * Get the list of allowed IPs for master organisation login, line separated
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getAdminLockdownList(string $contentType = self::contentTypes['getAdminLockdownList'][0])
    {
        list($response) = $this->getAdminLockdownListWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getAdminLockdownListWithHttpInfo
     *
     * Get the list of allowed IPs for master organisation login, line separated
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAdminLockdownListWithHttpInfo(string $contentType = self::contentTypes['getAdminLockdownList'][0])
    {
        $request = $this->getAdminLockdownListRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAdminLockdownListAsync
     *
     * Get the list of allowed IPs for master organisation login, line separated
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdminLockdownListAsync(string $contentType = self::contentTypes['getAdminLockdownList'][0])
    {
        return $this->getAdminLockdownListAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAdminLockdownListAsyncWithHttpInfo
     *
     * Get the list of allowed IPs for master organisation login, line separated
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdminLockdownListAsyncWithHttpInfo(string $contentType = self::contentTypes['getAdminLockdownList'][0])
    {
        $returnType = 'string';
        $request = $this->getAdminLockdownListRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAdminLockdownList'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAdminLockdownListRequest(string $contentType = self::contentTypes['getAdminLockdownList'][0])
    {


        $resourcePath = '/settings/orchd/admin-lockdown/list';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAdminLockdownStatus
     *
     * Check if master organisation IP lockdown is enabled
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return bool
     */
    public function getAdminLockdownStatus(string $contentType = self::contentTypes['getAdminLockdownStatus'][0])
    {
        list($response) = $this->getAdminLockdownStatusWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getAdminLockdownStatusWithHttpInfo
     *
     * Check if master organisation IP lockdown is enabled
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of bool, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAdminLockdownStatusWithHttpInfo(string $contentType = self::contentTypes['getAdminLockdownStatus'][0])
    {
        $request = $this->getAdminLockdownStatusRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'bool',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'bool',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAdminLockdownStatusAsync
     *
     * Check if master organisation IP lockdown is enabled
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdminLockdownStatusAsync(string $contentType = self::contentTypes['getAdminLockdownStatus'][0])
    {
        return $this->getAdminLockdownStatusAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAdminLockdownStatusAsyncWithHttpInfo
     *
     * Check if master organisation IP lockdown is enabled
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdminLockdownStatusAsyncWithHttpInfo(string $contentType = self::contentTypes['getAdminLockdownStatus'][0])
    {
        $returnType = 'bool';
        $request = $this->getAdminLockdownStatusRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAdminLockdownStatus'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAdminLockdownStatusRequest(string $contentType = self::contentTypes['getAdminLockdownStatus'][0])
    {


        $resourcePath = '/settings/orchd/admin-lockdown/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBackupRemoteStorageS3
     *
     * Get S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\BackupRemoteStorageS3
     */
    public function getBackupRemoteStorageS3(string $contentType = self::contentTypes['getBackupRemoteStorageS3'][0])
    {
        list($response) = $this->getBackupRemoteStorageS3WithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getBackupRemoteStorageS3WithHttpInfo
     *
     * Get S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\BackupRemoteStorageS3, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBackupRemoteStorageS3WithHttpInfo(string $contentType = self::contentTypes['getBackupRemoteStorageS3'][0])
    {
        $request = $this->getBackupRemoteStorageS3Request($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\BackupRemoteStorageS3',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\BackupRemoteStorageS3',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\BackupRemoteStorageS3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getBackupRemoteStorageS3Async
     *
     * Get S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBackupRemoteStorageS3Async(string $contentType = self::contentTypes['getBackupRemoteStorageS3'][0])
    {
        return $this->getBackupRemoteStorageS3AsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBackupRemoteStorageS3AsyncWithHttpInfo
     *
     * Get S3 object storage settings at platform level.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBackupRemoteStorageS3AsyncWithHttpInfo(string $contentType = self::contentTypes['getBackupRemoteStorageS3'][0])
    {
        $returnType = '\OpenAPI\Client\Model\BackupRemoteStorageS3';
        $request = $this->getBackupRemoteStorageS3Request($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBackupRemoteStorageS3'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBackupRemoteStorageS3Request(string $contentType = self::contentTypes['getBackupRemoteStorageS3'][0])
    {


        $resourcePath = '/v2/settings/backup/remote_storage/s3';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDemoMode
     *
     * Get the demo mode status of the orchd service
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDemoMode'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DemoMode
     */
    public function getDemoMode(string $contentType = self::contentTypes['getDemoMode'][0])
    {
        list($response) = $this->getDemoModeWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getDemoModeWithHttpInfo
     *
     * Get the demo mode status of the orchd service
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDemoMode'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DemoMode, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDemoModeWithHttpInfo(string $contentType = self::contentTypes['getDemoMode'][0])
    {
        $request = $this->getDemoModeRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DemoMode',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DemoMode',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DemoMode',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getDemoModeAsync
     *
     * Get the demo mode status of the orchd service
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDemoMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDemoModeAsync(string $contentType = self::contentTypes['getDemoMode'][0])
    {
        return $this->getDemoModeAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDemoModeAsyncWithHttpInfo
     *
     * Get the demo mode status of the orchd service
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDemoMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDemoModeAsyncWithHttpInfo(string $contentType = self::contentTypes['getDemoMode'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DemoMode';
        $request = $this->getDemoModeRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDemoMode'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDemoMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDemoModeRequest(string $contentType = self::contentTypes['getDemoMode'][0])
    {


        $resourcePath = '/v2/settings/demo_mode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGlobalServiceSetting
     *
     * Get the value for a particular global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function getGlobalServiceSetting($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        list($response) = $this->getGlobalServiceSettingWithHttpInfo($setting_kind, $contentType);
        return $response;
    }

    /**
     * Operation getGlobalServiceSettingWithHttpInfo
     *
     * Get the value for a particular global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGlobalServiceSettingWithHttpInfo($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        $request = $this->getGlobalServiceSettingRequest($setting_kind, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getGlobalServiceSettingAsync
     *
     * Get the value for a particular global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGlobalServiceSettingAsync($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        return $this->getGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGlobalServiceSettingAsyncWithHttpInfo
     *
     * Get the value for a particular global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGlobalServiceSettingAsyncWithHttpInfo($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        $returnType = 'mixed';
        $request = $this->getGlobalServiceSettingRequest($setting_kind, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGlobalServiceSetting'
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGlobalServiceSettingRequest($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {

        // verify the required parameter 'setting_kind' is set
        if ($setting_kind === null || (is_array($setting_kind) && count($setting_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_kind when calling getGlobalServiceSetting'
            );
        }


        $resourcePath = '/settings/service/{setting_kind}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($setting_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_kind' . '}',
                ObjectSerializer::toPathValue($setting_kind),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLogSettings
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLogSettings
     */
    public function getOrchdLogSettings(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        list($response) = $this->getOrchdLogSettingsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLogSettingsWithHttpInfo
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLogSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLogSettingsWithHttpInfo(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        $request = $this->getOrchdLogSettingsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OrchdLogSettings',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OrchdLogSettings',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLogSettings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrchdLogSettingsAsync
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLogSettingsAsync(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        return $this->getOrchdLogSettingsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLogSettingsAsyncWithHttpInfo
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLogSettingsAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLogSettings';
        $request = $this->getOrchdLogSettingsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLogSettings'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLogSettingsRequest(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {


        $resourcePath = '/settings/orchd/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklist
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyEmailList
     */
    public function getOrchdLoginPolicyEmailBlacklist(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyEmailBlacklistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklistWithHttpInfo
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyEmailList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyEmailBlacklistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        $request = $this->getOrchdLoginPolicyEmailBlacklistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklistAsync
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailBlacklistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        return $this->getOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList';
        $request = $this->getOrchdLoginPolicyEmailBlacklistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyEmailBlacklist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyEmailBlacklistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelist
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyEmailList
     */
    public function getOrchdLoginPolicyEmailWhitelist(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyEmailWhitelistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelistWithHttpInfo
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyEmailList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyEmailWhitelistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        $request = $this->getOrchdLoginPolicyEmailWhitelistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelistAsync
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailWhitelistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        return $this->getOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList';
        $request = $this->getOrchdLoginPolicyEmailWhitelistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyEmailWhitelist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyEmailWhitelistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklist
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyIpList
     */
    public function getOrchdLoginPolicyIpBlacklist(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyIpBlacklistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklistWithHttpInfo
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyIpList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyIpBlacklistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        $request = $this->getOrchdLoginPolicyIpBlacklistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklistAsync
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpBlacklistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        return $this->getOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyIpList';
        $request = $this->getOrchdLoginPolicyIpBlacklistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyIpBlacklist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyIpBlacklistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelist
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyIpList
     */
    public function getOrchdLoginPolicyIpWhitelist(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyIpWhitelistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelistWithHttpInfo
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyIpList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyIpWhitelistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        $request = $this->getOrchdLoginPolicyIpWhitelistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelistAsync
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpWhitelistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        return $this->getOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyIpList';
        $request = $this->getOrchdLoginPolicyIpWhitelistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyIpWhitelist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyIpWhitelistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicySettings
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicySettings
     */
    public function getOrchdLoginPolicySettings(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        list($response) = $this->getOrchdLoginPolicySettingsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicySettingsWithHttpInfo
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicySettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicySettingsWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        $request = $this->getOrchdLoginPolicySettingsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OrchdLoginPolicySettings',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OrchdLoginPolicySettings',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicySettings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicySettingsAsync
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicySettingsAsync(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        return $this->getOrchdLoginPolicySettingsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicySettingsAsyncWithHttpInfo
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicySettingsAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicySettings';
        $request = $this->getOrchdLoginPolicySettingsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicySettings'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicySettingsRequest(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProhibitedDomains
     *
     * Get the platform level prohibited domains as a newline separated list
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getProhibitedDomains(string $contentType = self::contentTypes['getProhibitedDomains'][0])
    {
        list($response) = $this->getProhibitedDomainsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getProhibitedDomainsWithHttpInfo
     *
     * Get the platform level prohibited domains as a newline separated list
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProhibitedDomainsWithHttpInfo(string $contentType = self::contentTypes['getProhibitedDomains'][0])
    {
        $request = $this->getProhibitedDomainsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getProhibitedDomainsAsync
     *
     * Get the platform level prohibited domains as a newline separated list
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProhibitedDomainsAsync(string $contentType = self::contentTypes['getProhibitedDomains'][0])
    {
        return $this->getProhibitedDomainsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProhibitedDomainsAsyncWithHttpInfo
     *
     * Get the platform level prohibited domains as a newline separated list
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProhibitedDomainsAsyncWithHttpInfo(string $contentType = self::contentTypes['getProhibitedDomains'][0])
    {
        $returnType = 'string';
        $request = $this->getProhibitedDomainsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProhibitedDomains'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProhibitedDomainsRequest(string $contentType = self::contentTypes['getProhibitedDomains'][0])
    {


        $resourcePath = '/settings/orchd/prohibited_domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSetting
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Setting
     */
    public function getSetting($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        list($response) = $this->getSettingWithHttpInfo($name, $contentType);
        return $response;
    }

    /**
     * Operation getSettingWithHttpInfo
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Setting, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingWithHttpInfo($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        $request = $this->getSettingRequest($name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Setting',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Setting',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Setting',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSettingAsync
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingAsync($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        return $this->getSettingAsyncWithHttpInfo($name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSettingAsyncWithHttpInfo
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingAsyncWithHttpInfo($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Setting';
        $request = $this->getSettingRequest($name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSetting'
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSettingRequest($name, string $contentType = self::contentTypes['getSetting'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getSetting'
            );
        }


        $resourcePath = '/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSettings
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SettingsFullListing
     */
    public function getSettings(string $contentType = self::contentTypes['getSettings'][0])
    {
        list($response) = $this->getSettingsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getSettingsWithHttpInfo
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SettingsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingsWithHttpInfo(string $contentType = self::contentTypes['getSettings'][0])
    {
        $request = $this->getSettingsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SettingsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SettingsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SettingsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSettingsAsync
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsync(string $contentType = self::contentTypes['getSettings'][0])
    {
        return $this->getSettingsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSettingsAsyncWithHttpInfo
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsyncWithHttpInfo(string $contentType = self::contentTypes['getSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SettingsFullListing';
        $request = $this->getSettingsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSettings'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSettingsRequest(string $contentType = self::contentTypes['getSettings'][0])
    {


        $resourcePath = '/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setAdminLockdownList
     *
     * Set admin lockdown list as a whole
     *
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setAdminLockdownList($body, string $contentType = self::contentTypes['setAdminLockdownList'][0])
    {
        $this->setAdminLockdownListWithHttpInfo($body, $contentType);
    }

    /**
     * Operation setAdminLockdownListWithHttpInfo
     *
     * Set admin lockdown list as a whole
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setAdminLockdownListWithHttpInfo($body, string $contentType = self::contentTypes['setAdminLockdownList'][0])
    {
        $request = $this->setAdminLockdownListRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setAdminLockdownListAsync
     *
     * Set admin lockdown list as a whole
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAdminLockdownListAsync($body, string $contentType = self::contentTypes['setAdminLockdownList'][0])
    {
        return $this->setAdminLockdownListAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setAdminLockdownListAsyncWithHttpInfo
     *
     * Set admin lockdown list as a whole
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAdminLockdownListAsyncWithHttpInfo($body, string $contentType = self::contentTypes['setAdminLockdownList'][0])
    {
        $returnType = '';
        $request = $this->setAdminLockdownListRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setAdminLockdownList'
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setAdminLockdownListRequest($body, string $contentType = self::contentTypes['setAdminLockdownList'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setAdminLockdownList'
            );
        }


        $resourcePath = '/settings/orchd/admin-lockdown/list';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setAdminLockdownStatus
     *
     * Set admin lockdown status
     *
     * @param  bool $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setAdminLockdownStatus($body, string $contentType = self::contentTypes['setAdminLockdownStatus'][0])
    {
        $this->setAdminLockdownStatusWithHttpInfo($body, $contentType);
    }

    /**
     * Operation setAdminLockdownStatusWithHttpInfo
     *
     * Set admin lockdown status
     *
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setAdminLockdownStatusWithHttpInfo($body, string $contentType = self::contentTypes['setAdminLockdownStatus'][0])
    {
        $request = $this->setAdminLockdownStatusRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setAdminLockdownStatusAsync
     *
     * Set admin lockdown status
     *
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAdminLockdownStatusAsync($body, string $contentType = self::contentTypes['setAdminLockdownStatus'][0])
    {
        return $this->setAdminLockdownStatusAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setAdminLockdownStatusAsyncWithHttpInfo
     *
     * Set admin lockdown status
     *
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAdminLockdownStatusAsyncWithHttpInfo($body, string $contentType = self::contentTypes['setAdminLockdownStatus'][0])
    {
        $returnType = '';
        $request = $this->setAdminLockdownStatusRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setAdminLockdownStatus'
     *
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdminLockdownStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setAdminLockdownStatusRequest($body, string $contentType = self::contentTypes['setAdminLockdownStatus'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setAdminLockdownStatus'
            );
        }


        $resourcePath = '/settings/orchd/admin-lockdown/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setGlobalServiceSetting
     *
     * Set a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome
     */
    public function setGlobalServiceSetting($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        list($response) = $this->setGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, $service_setting_value, $contentType);
        return $response;
    }

    /**
     * Operation setGlobalServiceSettingWithHttpInfo
     *
     * Set a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome, HTTP status code, HTTP response headers (array of strings)
     */
    public function setGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        $request = $this->setGlobalServiceSettingRequest($setting_kind, $setting_key, $service_setting_value, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Outcome',
                        $request,
                        $response,
                    );
                case 202:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Outcome',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Outcome',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation setGlobalServiceSettingAsync
     *
     * Set a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setGlobalServiceSettingAsync($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        return $this->setGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, $service_setting_value, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setGlobalServiceSettingAsyncWithHttpInfo
     *
     * Set a single global service setting
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Outcome';
        $request = $this->setGlobalServiceSettingRequest($setting_kind, $setting_key, $service_setting_value, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setGlobalServiceSetting'
     *
     * @param  \OpenAPI\Client\Model\SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup - default_dns_ttl (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setGlobalServiceSettingRequest($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {

        // verify the required parameter 'setting_kind' is set
        if ($setting_kind === null || (is_array($setting_kind) && count($setting_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_kind when calling setGlobalServiceSetting'
            );
        }

        // verify the required parameter 'setting_key' is set
        if ($setting_key === null || (is_array($setting_key) && count($setting_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_key when calling setGlobalServiceSetting'
            );
        }

        // verify the required parameter 'service_setting_value' is set
        if ($service_setting_value === null || (is_array($service_setting_value) && count($service_setting_value) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_setting_value when calling setGlobalServiceSetting'
            );
        }


        $resourcePath = '/settings/service/{setting_kind}/{setting_key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($setting_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_kind' . '}',
                ObjectSerializer::toPathValue($setting_kind),
                $resourcePath
            );
        }
        // path params
        if ($setting_key !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_key' . '}',
                ObjectSerializer::toPathValue($setting_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($service_setting_value)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($service_setting_value));
            } else {
                $httpBody = $service_setting_value;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLogSettings
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLogSettings($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        $this->setOrchdLogSettingsWithHttpInfo($orchd_log_settings, $contentType);
    }

    /**
     * Operation setOrchdLogSettingsWithHttpInfo
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLogSettingsWithHttpInfo($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        $request = $this->setOrchdLogSettingsRequest($orchd_log_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setOrchdLogSettingsAsync
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLogSettingsAsync($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        return $this->setOrchdLogSettingsAsyncWithHttpInfo($orchd_log_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLogSettingsAsyncWithHttpInfo
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLogSettingsAsyncWithHttpInfo($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLogSettingsRequest($orchd_log_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLogSettings'
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLogSettingsRequest($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {

        // verify the required parameter 'orchd_log_settings' is set
        if ($orchd_log_settings === null || (is_array($orchd_log_settings) && count($orchd_log_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_log_settings when calling setOrchdLogSettings'
            );
        }


        $resourcePath = '/settings/orchd/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_log_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_log_settings));
            } else {
                $httpBody = $orchd_log_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setProhibitedDomains
     *
     * Set the platform level prohibited domains
     *
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setProhibitedDomains($body, string $contentType = self::contentTypes['setProhibitedDomains'][0])
    {
        $this->setProhibitedDomainsWithHttpInfo($body, $contentType);
    }

    /**
     * Operation setProhibitedDomainsWithHttpInfo
     *
     * Set the platform level prohibited domains
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setProhibitedDomainsWithHttpInfo($body, string $contentType = self::contentTypes['setProhibitedDomains'][0])
    {
        $request = $this->setProhibitedDomainsRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setProhibitedDomainsAsync
     *
     * Set the platform level prohibited domains
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setProhibitedDomainsAsync($body, string $contentType = self::contentTypes['setProhibitedDomains'][0])
    {
        return $this->setProhibitedDomainsAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setProhibitedDomainsAsyncWithHttpInfo
     *
     * Set the platform level prohibited domains
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setProhibitedDomainsAsyncWithHttpInfo($body, string $contentType = self::contentTypes['setProhibitedDomains'][0])
    {
        $returnType = '';
        $request = $this->setProhibitedDomainsRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setProhibitedDomains'
     *
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setProhibitedDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setProhibitedDomainsRequest($body, string $contentType = self::contentTypes['setProhibitedDomains'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setProhibitedDomains'
            );
        }


        $resourcePath = '/settings/orchd/prohibited_domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateBackupRemoteStorageS3
     *
     * Update S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\UpdateBackupRemoteStorageS3 $update_backup_remote_storage_s3 update_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateBackupRemoteStorageS3($update_backup_remote_storage_s3, string $contentType = self::contentTypes['updateBackupRemoteStorageS3'][0])
    {
        $this->updateBackupRemoteStorageS3WithHttpInfo($update_backup_remote_storage_s3, $contentType);
    }

    /**
     * Operation updateBackupRemoteStorageS3WithHttpInfo
     *
     * Update S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\UpdateBackupRemoteStorageS3 $update_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBackupRemoteStorageS3WithHttpInfo($update_backup_remote_storage_s3, string $contentType = self::contentTypes['updateBackupRemoteStorageS3'][0])
    {
        $request = $this->updateBackupRemoteStorageS3Request($update_backup_remote_storage_s3, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateBackupRemoteStorageS3Async
     *
     * Update S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\UpdateBackupRemoteStorageS3 $update_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBackupRemoteStorageS3Async($update_backup_remote_storage_s3, string $contentType = self::contentTypes['updateBackupRemoteStorageS3'][0])
    {
        return $this->updateBackupRemoteStorageS3AsyncWithHttpInfo($update_backup_remote_storage_s3, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateBackupRemoteStorageS3AsyncWithHttpInfo
     *
     * Update S3 object storage settings at platform level.
     *
     * @param  \OpenAPI\Client\Model\UpdateBackupRemoteStorageS3 $update_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBackupRemoteStorageS3AsyncWithHttpInfo($update_backup_remote_storage_s3, string $contentType = self::contentTypes['updateBackupRemoteStorageS3'][0])
    {
        $returnType = '';
        $request = $this->updateBackupRemoteStorageS3Request($update_backup_remote_storage_s3, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateBackupRemoteStorageS3'
     *
     * @param  \OpenAPI\Client\Model\UpdateBackupRemoteStorageS3 $update_backup_remote_storage_s3 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBackupRemoteStorageS3'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateBackupRemoteStorageS3Request($update_backup_remote_storage_s3, string $contentType = self::contentTypes['updateBackupRemoteStorageS3'][0])
    {

        // verify the required parameter 'update_backup_remote_storage_s3' is set
        if ($update_backup_remote_storage_s3 === null || (is_array($update_backup_remote_storage_s3) && count($update_backup_remote_storage_s3) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_backup_remote_storage_s3 when calling updateBackupRemoteStorageS3'
            );
        }


        $resourcePath = '/v2/settings/backup/remote_storage/s3';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_backup_remote_storage_s3)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_backup_remote_storage_s3));
            } else {
                $httpBody = $update_backup_remote_storage_s3;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSetting
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateSetting($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        $this->updateSettingWithHttpInfo($name, $update_setting_request, $contentType);
    }

    /**
     * Operation updateSettingWithHttpInfo
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSettingWithHttpInfo($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        $request = $this->updateSettingRequest($name, $update_setting_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateSettingAsync
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSettingAsync($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        return $this->updateSettingAsyncWithHttpInfo($name, $update_setting_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSettingAsyncWithHttpInfo
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSettingAsyncWithHttpInfo($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        $returnType = '';
        $request = $this->updateSettingRequest($name, $update_setting_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSetting'
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSettingRequest($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updateSetting'
            );
        }

        // verify the required parameter 'update_setting_request' is set
        if ($update_setting_request === null || (is_array($update_setting_request) && count($update_setting_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_setting_request when calling updateSetting'
            );
        }


        $resourcePath = '/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_setting_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_setting_request));
            } else {
                $httpBody = $update_setting_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
