<?php
/**
 * CanUse
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * CanUse Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CanUse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CanUse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ftp' => 'bool',
        'file_manager' => 'bool',
        'php_versions' => '\OpenAPI\Client\Model\PhpVersion[]',
        'redis' => 'bool',
        'mod_sec' => 'bool',
        'backup' => 'bool',
        'mysql_kind' => '\OpenAPI\Client\Model\MysqlKind'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ftp' => null,
        'file_manager' => null,
        'php_versions' => null,
        'redis' => null,
        'mod_sec' => null,
        'backup' => null,
        'mysql_kind' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'ftp' => false,
        'file_manager' => false,
        'php_versions' => false,
        'redis' => false,
        'mod_sec' => false,
        'backup' => false,
        'mysql_kind' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ftp' => 'ftp',
        'file_manager' => 'fileManager',
        'php_versions' => 'phpVersions',
        'redis' => 'redis',
        'mod_sec' => 'modSec',
        'backup' => 'backup',
        'mysql_kind' => 'mysqlKind'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ftp' => 'setFtp',
        'file_manager' => 'setFileManager',
        'php_versions' => 'setPhpVersions',
        'redis' => 'setRedis',
        'mod_sec' => 'setModSec',
        'backup' => 'setBackup',
        'mysql_kind' => 'setMysqlKind'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ftp' => 'getFtp',
        'file_manager' => 'getFileManager',
        'php_versions' => 'getPhpVersions',
        'redis' => 'getRedis',
        'mod_sec' => 'getModSec',
        'backup' => 'getBackup',
        'mysql_kind' => 'getMysqlKind'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('ftp', $data ?? [], null);
        $this->setIfExists('file_manager', $data ?? [], null);
        $this->setIfExists('php_versions', $data ?? [], null);
        $this->setIfExists('redis', $data ?? [], null);
        $this->setIfExists('mod_sec', $data ?? [], null);
        $this->setIfExists('backup', $data ?? [], null);
        $this->setIfExists('mysql_kind', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['ftp'] === null) {
            $invalidProperties[] = "'ftp' can't be null";
        }
        if ($this->container['file_manager'] === null) {
            $invalidProperties[] = "'file_manager' can't be null";
        }
        if ($this->container['php_versions'] === null) {
            $invalidProperties[] = "'php_versions' can't be null";
        }
        if ($this->container['redis'] === null) {
            $invalidProperties[] = "'redis' can't be null";
        }
        if ($this->container['mod_sec'] === null) {
            $invalidProperties[] = "'mod_sec' can't be null";
        }
        if ($this->container['backup'] === null) {
            $invalidProperties[] = "'backup' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ftp
     *
     * @return bool
     */
    public function getFtp()
    {
        return $this->container['ftp'];
    }

    /**
     * Sets ftp
     *
     * @param bool $ftp ftp
     *
     * @return self
     */
    public function setFtp($ftp)
    {
        if (is_null($ftp)) {
            throw new \InvalidArgumentException('non-nullable ftp cannot be null');
        }
        $this->container['ftp'] = $ftp;

        return $this;
    }

    /**
     * Gets file_manager
     *
     * @return bool
     */
    public function getFileManager()
    {
        return $this->container['file_manager'];
    }

    /**
     * Sets file_manager
     *
     * @param bool $file_manager file_manager
     *
     * @return self
     */
    public function setFileManager($file_manager)
    {
        if (is_null($file_manager)) {
            throw new \InvalidArgumentException('non-nullable file_manager cannot be null');
        }
        $this->container['file_manager'] = $file_manager;

        return $this;
    }

    /**
     * Gets php_versions
     *
     * @return \OpenAPI\Client\Model\PhpVersion[]
     */
    public function getPhpVersions()
    {
        return $this->container['php_versions'];
    }

    /**
     * Sets php_versions
     *
     * @param \OpenAPI\Client\Model\PhpVersion[] $php_versions php_versions
     *
     * @return self
     */
    public function setPhpVersions($php_versions)
    {
        if (is_null($php_versions)) {
            throw new \InvalidArgumentException('non-nullable php_versions cannot be null');
        }
        $this->container['php_versions'] = $php_versions;

        return $this;
    }

    /**
     * Gets redis
     *
     * @return bool
     */
    public function getRedis()
    {
        return $this->container['redis'];
    }

    /**
     * Sets redis
     *
     * @param bool $redis redis
     *
     * @return self
     */
    public function setRedis($redis)
    {
        if (is_null($redis)) {
            throw new \InvalidArgumentException('non-nullable redis cannot be null');
        }
        $this->container['redis'] = $redis;

        return $this;
    }

    /**
     * Gets mod_sec
     *
     * @return bool
     */
    public function getModSec()
    {
        return $this->container['mod_sec'];
    }

    /**
     * Sets mod_sec
     *
     * @param bool $mod_sec mod_sec
     *
     * @return self
     */
    public function setModSec($mod_sec)
    {
        if (is_null($mod_sec)) {
            throw new \InvalidArgumentException('non-nullable mod_sec cannot be null');
        }
        $this->container['mod_sec'] = $mod_sec;

        return $this;
    }

    /**
     * Gets backup
     *
     * @return bool
     */
    public function getBackup()
    {
        return $this->container['backup'];
    }

    /**
     * Sets backup
     *
     * @param bool $backup backup
     *
     * @return self
     */
    public function setBackup($backup)
    {
        if (is_null($backup)) {
            throw new \InvalidArgumentException('non-nullable backup cannot be null');
        }
        $this->container['backup'] = $backup;

        return $this;
    }

    /**
     * Gets mysql_kind
     *
     * @return \OpenAPI\Client\Model\MysqlKind|null
     */
    public function getMysqlKind()
    {
        return $this->container['mysql_kind'];
    }

    /**
     * Sets mysql_kind
     *
     * @param \OpenAPI\Client\Model\MysqlKind|null $mysql_kind mysql_kind
     *
     * @return self
     */
    public function setMysqlKind($mysql_kind)
    {
        if (is_null($mysql_kind)) {
            throw new \InvalidArgumentException('non-nullable mysql_kind cannot be null');
        }
        $this->container['mysql_kind'] = $mysql_kind;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


